% Get the eigenvectors
% Evolve wavefunction from initial point (lower triangle corner) to the
% measurement node
% ------------------------------------------------------------------------

function amp = get_g0_mech_cav(kpeak, scat, dis, ct, vel, g0peak)

% Eigenvectors
evec = zeros(2, size(kpeak.horz, 2));
evec(1,:) = 1;

sol_node = zeros(2, size(kpeak.horz, 2));

% Define all the transfer matrices
T1 = transfer_matrix(scat.r1, scat.t1, 'usual');
T2 = transfer_matrix(scat.r2, scat.t2, 'usual');
T1m = transfer_matrix(scat.r1, scat.t1, 'mirror');

ct.horz_top = (ct.tri_side - ct.horz_bot)/2;
ct.slant_top = ct.tri_side - ct.slant_bot;

for i=1:size(kpeak.horz, 2)
    Twg_sb = transfer_matrix(scat.r1, scat.t1, 'waveguide', ...
        kpeak.slant(i)*ct.slant_bot*ct.amech);
    Twg_ht = transfer_matrix(scat.r1, scat.t1, 'waveguide', ...
        kpeak.horz(i)*ct.horz_top*ct.amech);
    Twg_st = transfer_matrix(scat.r1, scat.t1, 'waveguide', ...
        kpeak.slant(i)*ct.slant_top*ct.amech);
    Twg_hb = transfer_matrix(scat.r1, scat.t1, 'waveguide', ...
        kpeak.horz(i)*ct.horz_bot*ct.amech);
    
    % Transfer matrix for the whole round trip
    Tct = Twg_hb*T1m*Twg_sb*T1*Twg_ht*T1m*Twg_st*T2*Twg_st*...
        T1*Twg_ht*T1m*Twg_sb*T1;
    
    % Get eigenvectors
    evec(2,i) = (1 - Tct(1,1))/Tct(1,2);
    
    % Get normalization constant B
    Twg_mid_sb = transfer_matrix(scat.r1, scat.t1, 'waveguide', ...
        kpeak.slant(i)*ct.slant_bot*ct.amech/2);
    A_sb = Twg_mid_sb*T1*evec(:,i);
    A_sb = sum(abs(A_sb))/2;
    
    Twg_mid_ht = transfer_matrix(scat.r1, scat.t1, 'waveguide', ...
        kpeak.horz(i)*ct.horz_top/2*ct.amech/2);
    A_ht = Twg_mid_ht*T1m*Twg_sb*T1*evec(:,i);
    A_ht = sum(abs(A_ht))/2;
    
    Twg_mid_st = transfer_matrix(scat.r1, scat.t1, 'waveguide', ...
        kpeak.slant(i)*ct.slant_top*ct.amech/2);
    A_st = Twg_mid_st*T1*Twg_ht*T1m*Twg_sb*T1*evec(:,i);
    A_st = sum(abs(A_st))/2;
    
    Twg_mid_hb = transfer_matrix(scat.r1, scat.t1, 'waveguide', ...
        kpeak.horz(i)*ct.horz_bot*ct.amech/2);
    A_hb = Twg_mid_hb*T1m*Twg_sb*T1*Twg_ht*T1m*Twg_st*T2*Twg_st*...
        T1*Twg_ht*T1m*Twg_sb*T1*evec(:,i);
    A_hb = sum(abs(A_hb))/2;
    
    B = (2/(3*ct.tri_side)*(2*ct.slant_bot*A_sb^2/vel.slant(i) + ...
        2*ct.horz_top*A_ht^2/vel.horz(i) + ...
        2*ct.slant_top*A_st^2/vel.slant(i) + ...
        ct.horz_bot*A_hb^2/vel.horz(i) ...
        ))^(-1/2);
    
    % Get signal amplitude at the measurement node
    if dis<=ct.slant_bot*ct.amech
        Twg_sb = transfer_matrix(scat.r1, scat.t1, 'waveguide', ...
        kpeak.slant(i)*dis);
        sol_node(:,i) = Twg_sb*T1*evec(:,i);
        
        prob = g0peak.slant(i)/sqrt(vel.slant(i))*...
            sum(abs(sol_node(:,i)))/2;
    
    elseif dis>ct.slant_bot*ct.amech && dis<=(ct.slant_bot + ...
            ct.horz_top)*ct.amech
        Twg_ht = transfer_matrix(scat.r1, scat.t1, 'waveguide', ...
            kpeak.horz(i)*(dis - ct.slant_bot*ct.amech));
        sol_node(:,i) = Twg_ht*T1m*Twg_sb*T1*evec(:,i);
        
        prob = g0peak.horz(i)/sqrt(vel.horz(i))*...
            sum(abs(sol_node(:,i)))/2;
    
    elseif dis>(ct.slant_bot + ct.horz_top)*ct.amech &&...
            dis<=(3*ct.tri_side - ct.horz_bot)/2*ct.amech
        Twg_st = transfer_matrix(scat.r1, scat.t1, 'waveguide', ...
        kpeak.slant(i)*(dis - (ct.slant_bot + ...
        ct.horz_top)*ct.amech));
        sol_node(:,i) = Twg_st*T1*Twg_ht*T1m*Twg_sb*T1*evec(:,i);
        
        prob = g0peak.slant(i)/sqrt(vel.slant(i))*...
            sum(abs(sol_node(:,i)))/2;
        
    elseif dis>(3*ct.tri_side - ct.horz_bot)/2*ct.amech && ...
            dis<=(3*ct.tri_side - ct.horz_bot)/2*ct.amech + ...
            (ct.tri_side - ct.slant_bot)*ct.amech
        Twg_st2 = transfer_matrix(scat.r1, scat.t1, 'waveguide', ...
        kpeak.slant(i)*(dis - (3*ct.tri_side - ct.horz_bot)/2*ct.amech));
        sol_node(:,i) = Twg_st2*T2*Twg_st*T1*Twg_ht*T1m*Twg_sb*T1*evec(:,i);
        
        prob = g0peak.slant(i)/sqrt(vel.slant(i))*...
            sum(abs(sol_node(:,i)))/2;
        
    elseif dis>(3*ct.tri_side - ct.horz_bot)/2*ct.amech + ...
            (ct.tri_side - ct.slant_bot)*ct.amech && ...
            dis<=(3*ct.tri_side - ct.horz_bot - ct.slant_bot)*ct.amech
        Twg_ht2 = transfer_matrix(scat.r1, scat.t1, 'waveguide', ...
            kpeak.horz(i)*(dis - ((3*ct.tri_side - ct.horz_bot)/2*ct.amech + ...
            (ct.tri_side - ct.slant_bot)*ct.amech)));
        sol_node(:,i) = Twg_ht2*T1m*Twg_st*T2*Twg_st*T1*Twg_ht*T1m*Twg_sb*T1*evec(:,i);
        
        prob = g0peak.horz(i)/sqrt(vel.horz(i))*...
            sum(abs(sol_node(:,i)))/2;
        
    elseif dis>(3*ct.tri_side - ct.horz_bot - ct.slant_bot)*ct.amech && ...
            dis<=(3*ct.tri_side - ct.horz_bot)*ct.amech
        Twg_sb2 = transfer_matrix(scat.r1, scat.t1, 'waveguide', ...
        kpeak.slant(i)*(dis - (3*ct.tri_side - ct.horz_bot - ...
        ct.slant_bot)*ct.amech));
        sol_node(:,i) = Twg_sb2*T1*Twg_ht*T1m*Twg_st*T2*Twg_st*T1*Twg_ht*T1m*Twg_sb*T1*evec(:,i);
        
        prob = g0peak.slant(i)/sqrt(vel.slant(i))*...
            sum(abs(sol_node(:,i)))/2;
        
    elseif dis>(3*ct.tri_side - ct.horz_bot)*ct.amech && ...
            dis<3*ct.tri_side*ct.amech
        Twg_hb2 = transfer_matrix(scat.r1, scat.t1, 'waveguide', ...
            kpeak.horz(i)*(dis - (3*ct.tri_side - ct.horz_bot)*ct.amech));
        sol_node(:,i) = Twg_hb2*T1m*Twg_sb*T1*Twg_ht*T1m*Twg_st*T2*Twg_st*...
            T1*Twg_ht*T1m*Twg_sb*T1*evec(:,i);
        
        prob = g0peak.horz(i)/sqrt(vel.horz(i))*...
            sum(abs(sol_node(:,i)))/2;
    end

    amp(i) = abs(2*pi*B*prob*2*cos(angle(sol_node(2,i)/sol_node(1,i))/2));
       
%     disp(A_st);
%     disp(sum(abs(sol_node(:,i)))/2);
end

% disp( ['Maximum absolute value of a component of the eigenvector: '...
%         , num2str(max(max(abs(evec))))]  );
% disp( ['Minimum absolute value of a component of the eigenvector: '...
%         , num2str(min(min(abs(evec))))]  );
%     
% disp( ['Maximum absolute value of a component at the measured node: '...
%     , num2str(max(max(abs(sol_node))))]  );
% disp( ['Minimum absolute value of a component at the measured node: '...
%         , num2str(min(min(abs(sol_node))))]  );

end